require('dotenv').config();

const express = require('express');
const cors = require('cors');
const morgan = require('morgan');
const helmet = require('helmet');


const middlewares = require('./middlewares');
const apiV1 = require('./api/v1');

const app = express();

app.use(morgan('dev'));
app.use(helmet());
app.use(cors());
app.use(express.json({limit: '50mb'}));


app.use('/api/v1', apiV1);

// app.use(middlewares.notFound);
// app.use(middlewares.errorHandler);

module.exports = app;