const express = require('express');
const e = require("express");

const db = require('monk')(
	`${process.env.MONGO_URL}/${process.env.MONGO_DB}`
);

const {maps, navi, variations} = require('./user/variations');
const {logsSchema, mapLogSchema} = require('./user/schema');


if(!db){
	console.log('no connection')
	throw new Error("No mongo Connection!")
}

let users = null;

db.then(() => {
	console.info('Mongo: Connected correctly to server')

    users = db.get('users');

    if(!db.get('users')) {
        users = db.create('users');
        console.info('Mongo: Created \'users\' collection');
    }

    console.info('Mongo: users are ready');
}).catch( (e) => {
    console.error(e);
})


/*if(!db.get('users')) {
    db.create('users');
    console.info('Mongo: Created \'users\' collection');
}
*/

// console.log(db.get('users'));

// const users = db.get('users');

const router = express.Router();


router.get('/ready', (req, res) => {
    users 
        ? res.json({message: 'ok'})
        : res.status(503).json({message: 'Not ready yet'});
})

// create user
router.post('/', async (req, res, next) => {
	try {
		const variation = variations[(await users.count()) % variations.length];
		const user = await users.insert({variation: variation, logs: [], mapLogs: []});
		return res.json({
			participantId: user._id,
			variationId: user.variation.id,
			levels: user.variation.levelCombinations
		});
	} catch (error) {
		console.error(error)
		next(error);
	}
});

// update user
router.put('/:id/map', async (req, res, next) => {
	try {
		const { id } = req.params;

		const result = mapLogSchema.validate(req.body);

		if(result.error || !(await users.findOne({_id: id})))
			return next(result.error);

		const resultFormatted = result.value.map(r => {
			r.ßtype = r.$type;
			delete r.$type;
			return r;
		});

		await users.update({ _id: id }, { $push: { 'mapLogs' : resultFormatted } });

		res.json({message: 'ok'})
	} catch (error) {
		next(error);
	}
});

router.put('/:id', async (req, res, next) => {
	try {
		const { id } = req.params;

		const result = logsSchema.validate(req.body);

		if(result.error || !(await users.findOne({_id: id})))
			return next(result.error);

		const resultFormatted = result.value.map(r => {
			r.ßtype = r.$type;
			delete r.$type;
			return r;
		});

		await users.update({ _id: id }, { $set: { logs: resultFormatted } });

		res.json({message: 'ok'})
	} catch (error) {
		next(error);
	}
});

router.get('/all', async (req, res, next) => {
	try {
		const { id } = req.params;

		const userList = await users.find({});

		if(!userList)
			return res.json(null);

        res.json( 
            (   req.query.user == process.env.ADMIN_USER && process.env.ADMIN_USER != "" 
             && req.query.pass == process.env.ADMIN_PASS && process.env.ADMIN_PASS != "")
                ? userList.map(u => {
                    return {id: u._id, variation: u.variation.id}
                })
                : userList.map(u => u.variation.id)
        )
	} catch (error) {
		next(error);
	}
});

router.get('/:id', async (req, res, next) => {
	try {
		const { id } = req.params;

		const user = await users.findOne({_id: id});

		if(!user)
			return res.json(null);

		user.logs = user.logs.map(r => {
			r.$type = r.ßtype;
			delete r.ßtype;
			return r;
		});

		user.mapLogs.map(mLog => mLog.map(r => {
			r.$type = r.ßtype;
			delete r.ßtype;
			return r;
		}));

		res.json(user ? user : null)
	} catch (error) {
		next(error);
	}
});

module.exports = router;
